#include <iostream>
#include <pigpio.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

static void err_handler (int sig) {
    gpioTerminate();
    signal(SIGINT, SIG_DFL);
    kill(getppid(), SIGINT);
    kill(getpid(), SIGINT);
    exit(0);
}

static void exit_handler () {
    gpioTerminate();
}

int inputPin = 18;
int outputPin = 20;

int main () {
    if (gpioInitialise() < 0) return 1;
    signal(SIGQUIT, err_handler);
    signal(SIGINT, err_handler);
    signal(SIGTERM, err_handler);
    signal(SIGABRT, err_handler);
    atexit(exit_handler);
    gpioSetMode(inputPin, PI_INPUT);
    gpioSetMode(outputPin, PI_OUTPUT);
    gpioSetPullUpDown(inputPin, PI_PUD_DOWN);
    while(1) {
        int inputVal = gpioRead(inputPin);
        gpioWrite(outputPin, inputVal);
        time_sleep(0.1);
    }
}


